// config: norepeat

#include "GetObjects.js"
#include "GetLine.js"

function DoRevolve()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowCurves();
	
	if ( !GetObjects( objectpicker ) )
		return;

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectionPrompt' );
	moi.ui.hideUI( 'done' );
	moi.ui.showUI( 'FirstLinePrompt' );
	moi.ui.showUI( 'RevolveOptions' );
	moi.ui.endUIUpdate();
	
	moi.ui.commandUI.angle.value = 360.0;

	var points = new Array();

	if ( !GetLine( points ) )
		return;

	var factory = moi.command.createFactory( 'revolve' );
	factory.setInput( 0, objectpicker.objects );
		
	factory.setInput( 1, points[0] );
	factory.setInput( 2, points[1] );
	factory.setInput( 3, moi.ui.commandUI.angle.value );
	factory.setInput( 4, moi.ui.commandUI.capends.value );
	
	factory.update();
	factory.commit();
}

DoRevolve();
